/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.client.handler.PiglinHeadModelHandler;
import fuzs.barteringstation.client.init.ModClientRegistry;
import fuzs.barteringstation.config.ClientConfig;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class BarteringStationScreen
extends AbstractContainerScreen<BarteringStationMenu> {
    private static final ResourceLocation BARTERING_STATION_LOCATION = new ResourceLocation("barteringstation", "textures/gui/container/bartering_station.png");
    public static final int ARROW_SIZE_X = 24;
    public static final int ARROW_SIZE_Y = 18;
    private SkullModelBase skullModel;

    public BarteringStationScreen(BarteringStationMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.skullModel = new SkullModel(this.f_96541_.m_167973_().m_171103_(ModClientRegistry.PIGLIN_HEAD_MODEL_LAYER_LOCATION));
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (((ClientConfig)BarteringStation.CONFIG.get(ClientConfig.class)).cooldownRenderType.overlay()) {
            this.renderCooldownOverlays();
        }
        this.m_7025_(poseStack, mouseX, mouseY);
        int startX = this.f_97735_ + 53;
        int startY = this.f_97736_ + 20;
        if (startX <= mouseX && startY <= mouseY && mouseX < startX + 16 && mouseY < startY + 16) {
            MutableComponent component = Component.m_237110_((String)"gui.barteringstation.bartering_station.piglins", (Object[])new Object[]{BarteringStationScreen.makePiglinComponent(((BarteringStationMenu)this.f_97732_).getNearbyPiglins())});
            this.m_96602_(poseStack, (Component)component, mouseX, mouseY);
        }
    }

    private static MutableComponent makePiglinComponent(int nearbyPiglins) {
        return Component.m_237113_((String)String.valueOf(nearbyPiglins)).m_130940_(nearbyPiglins > 0 ? ChatFormatting.GOLD : ChatFormatting.RED);
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BARTERING_STATION_LOCATION);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (((ClientConfig)BarteringStation.CONFIG.get(ClientConfig.class)).cooldownRenderType.arrows()) {
            this.renderBgCooldownArrows(poseStack);
        }
        this.renderPiglinHead(53, 20, 150);
        this.decoratePiglinHead(53, 20, 150);
    }

    private void renderPiglinHead(int posX, int posY, int blitOffset) {
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        PiglinHeadModelHandler.INSTANCE.renderPiglinHeadGuiModel(posX, posY, blitOffset, this.skullModel);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69482_();
    }

    private void decoratePiglinHead(int posX, int posY, int blitOffset) {
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_((double)this.f_97735_, (double)this.f_97736_, (double)blitOffset + 200.0);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        MutableComponent component = BarteringStationScreen.makePiglinComponent(((BarteringStationMenu)this.f_97732_).getNearbyPiglins());
        this.f_96547_.m_92841_((Component)component, (float)(posX + 19 - 2 - this.f_96547_.m_92852_((FormattedText)component)), (float)(posY + 6 + 3), -1, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)multibuffersource$buffersource, false, 0, 0xF000F0);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    private void renderBgCooldownArrows(PoseStack poseStack) {
        int arrow1Progress = ((BarteringStationMenu)this.f_97732_).getTopArrowProgress();
        this.m_93228_(poseStack, this.f_97735_ + 49, this.f_97736_ + 40, 176, 0, arrow1Progress, 18);
        int arrow2Progress = ((BarteringStationMenu)this.f_97732_).getBottomArrowProgress();
        this.m_93228_(poseStack, this.f_97735_ + 49 + 24 - arrow2Progress, this.f_97736_ + 53, 200 - arrow2Progress, 18, arrow2Progress, 18);
    }

    private void renderCooldownOverlays() {
        float cooldownProgress = ((BarteringStationMenu)this.f_97732_).getCooldownProgress();
        if (cooldownProgress > 0.0f && cooldownProgress < 1.0f) {
            PoseStack posestack = RenderSystem.m_157191_();
            posestack.m_85836_();
            posestack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
            RenderSystem.m_157182_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < 6 && i < ((BarteringStationMenu)this.f_97732_).f_38839_.size(); ++i) {
                Slot slot = (Slot)((BarteringStationMenu)this.f_97732_).f_38839_.get(i);
                if (!slot.m_6659_() || !slot.m_6657_()) continue;
                this.renderSlotCooldownOverlay(slot.f_40220_, slot.f_40221_, cooldownProgress);
            }
            posestack.m_85849_();
            RenderSystem.m_157182_();
            RenderSystem.m_69482_();
        }
    }

    private void renderSlotCooldownOverlay(int posX, int posY, float cooldownProgress) {
        if (cooldownProgress > 0.0f) {
            this.m_93250_(100);
            this.f_96542_.f_115093_ = 100.0f;
            RenderSystem.m_69465_();
            RenderSystem.m_69472_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            Tesselator tesselator1 = Tesselator.m_85913_();
            BufferBuilder bufferbuilder1 = tesselator1.m_85915_();
            this.fillRect(bufferbuilder1, posX, posY + Mth.m_14143_((float)(16.0f * (1.0f - cooldownProgress))), 16, Mth.m_14167_((float)(16.0f * cooldownProgress)), 255, 255, 255, 127);
            RenderSystem.m_69493_();
            RenderSystem.m_69482_();
            this.f_96542_.f_115093_ = 0.0f;
            this.m_93250_(0);
        }
    }

    private void fillRect(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        renderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        renderer.m_5483_((double)x, (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)x, (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        renderer.m_5483_((double)(x + width), (double)y, 0.0).m_6122_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)renderer.m_231175_());
    }
}

